import matplotlib.pyplot as plt
import matplotlib.patches as patches

# Define grid size
rows, cols = 6, 4

# Define colors for pieces
colors = {
    "rightl0": "blue",
    "rightl1": "green",
    "square0": "red",
    "square1": "yellow",
    "clear": "white"
}

# Create figure and axes
fig, ax = plt.subplots(figsize=(6, 9))
ax.set_xlim(0, cols)
ax.set_ylim(0, rows)
ax.set_aspect('equal')
ax.set_xticks([])
ax.set_yticks([])

# Draw grid cells
for row in range(rows):
    for col in range(cols):
        pos = f"f{row}-{col}f"
        if pos in ["f5-0f", "f5-1f", "f5-2f", "f5-3f", 
                   "f4-0f", "f4-1f", "f4-2f", "f4-3f",
                   "f3-2f", "f3-3f", "f2-1f", "f2-3f",
                   "f1-3f", "f0-1f", "f0-2f", "f0-3f"]:
            color = colors["clear"]
            status = "clear"
        else:
            color = "none"
            status = "occupied"
        
        rect = patches.Rectangle((col, rows - row - 1), 1, 1, linewidth=1, edgecolor='black', facecolor=color)
        ax.add_patch(rect)
        ax.text(col + 0.5, rows - row - 0.5, f"{pos}\n{status}", ha='center', va='center', fontsize=8)

# Draw pieces
# rightl0
rightl0_positions = [(0, 3), (1, 3), (0, 2)]
for col, row in rightl0_positions:
    rect = patches.Rectangle((col, rows - row - 1), 1, 1, linewidth=2, edgecolor='black', facecolor=colors["rightl0"])
    ax.add_patch(rect)
    ax.text(col + 0.5, rows - row - 0.3, "rightl0", ha='center', va='center', fontsize=8, color='white')

# rightl1
rightl1_positions = [(0, 1), (1, 1), (0, 0)]
for col, row in rightl1_positions:
    rect = patches.Rectangle((col, rows - row - 1), 1, 1, linewidth=2, edgecolor='black', facecolor=colors["rightl1"])
    ax.add_patch(rect)
    ax.text(col + 0.5, rows - row - 0.3, "rightl1", ha='center', va='center', fontsize=8, color='white')

# square0
square0_position = (2, 1)
rect = patches.Rectangle((square0_position[0], rows - square0_position[1] - 1), 1, 1, linewidth=2, edgecolor='black', facecolor=colors["square0"])
ax.add_patch(rect)
ax.text(square0_position[0] + 0.5, rows - square0_position[1] - 0.3, "square0", ha='center', va='center', fontsize=8, color='white')

# square1
square1_position = (2, 2)
rect = patches.Rectangle((square1_position[0], rows - square1_position[1] - 1), 1, 1, linewidth=2, edgecolor='black', facecolor=colors["square1"])
ax.add_patch(rect)
ax.text(square1_position[0] + 0.5, rows - square1_position[1] - 0.3, "square1", ha='center', va='center', fontsize=8, color='black')

# Add legend
handles = [patches.Patch(color=colors[key], label=key) for key in ["rightl0", "rightl1", "square0", "square1", "clear"]]
ax.legend(handles=handles, loc='upper right', bbox_to_anchor=(1.3, 1))

# Save figure
plt.savefig("tetris/one_shot/ini_diagram_code/attempts/attempt_6.png", bbox_inches='tight')
plt.show()